#ifndef _MOD_H
#define _MOD_H

#include <fstream>
#include <string.h>
#include "Strcasecmp.h"

using namespace std;

class Mod {
public:
	Mod(const char * _name = "", const char * _type = "", const char * _con = "", const char * _group = "");
	Mod(const Mod & x);
	Mod & operator = (const Mod & x);
	~Mod(void);

	void name(const char * _name);
	void type(const char * _type);
	void con(const char * _con);
	void group(const char * _group);

	char * name() const;
	char * type() const;
	char * con() const;
	char * group() const;

	bool operator == (const Mod & x) const;
	bool operator != (const Mod & x) const;

	void printOn(ostream & o) const;

private:
	char * _name;
	char * _type;
	char * _con;
	char * _group;
};

ostream & operator << (ostream & o, const Mod & x);

#endif